﻿using System;
using System.Windows.Forms;
using RDR2;
using RDR2.UI;
using RDR2.Native;
using RDR2.Math;

namespace HCL_Superpower_03
{
    public class Main : Script
    {
        Player player = Game.Player;
        Ped playerPed = Game.Player.Character;
        bool EXPCasting = false;
        int EXPNumber = 1;
        int MaxEXP = 25;
        float TKLength = 2.5f;
        Entity TKEntity = null;

        public Main()
        {
            KeyDown += OnKeyDown;
            KeyUp += OnKeyUp;
            Tick += OnTick;
            Interval = 1;
        }

        private void OnTick(object sender, EventArgs e)
        {
            Ped playerPed = Game.Player.Character;   
            if (TKEntity != null)
            {
                     if (World.GetDistance(playerPed.Position, TKEntity.Position) > 200 || (Function.Call<bool>(Hash.IS_ENTITY_A_PED, TKEntity) && TKEntity.IsDead))
                     {
                              if (Function.Call<bool>(Hash.IS_ENTITY_A_PED, TKEntity))
                              {
                                      Function.Call(Hash.SET_PED_GRAVITY, TKEntity, true);
                                      Function.Call(Hash.SET_PED_CAN_RAGDOLL, TKEntity, true);
                              }
                             else
                             {
                                      Function.Call(Hash.SET_ENTITY_HAS_GRAVITY, TKEntity, true);
                             }
                             TKEntity = null;
                             TKLength = 2.5f;
                             RDR2.UI.Screen.ShowSubtitle("Telekinesis Off");
                     }
                     else
                     {
                             Vector3 AAAA = new Vector3(GameplayCamera.Direction.X * TKLength, GameplayCamera.Direction.Y * TKLength, (GameplayCamera.Direction.Z * TKLength +1f));
                             Vector3 StarPosition = playerPed.Position + AAAA;
                             TKEntity.ApplyForce((StarPosition - TKEntity.Position) * 3f);  
                             Function.Call(Hash.SET_ENTITY_VELOCITY, TKEntity, 0, 0, 0);
                             RDR2.UI.Screen.ShowSubtitle("Telekinesis On");
                             if (Game.IsKeyPressed(Keys.D1) && TKLength < 200)
                             {
                                        TKLength = TKLength + 0.5f; 
                             }
                             if (Game.IsKeyPressed(Keys.D2))
                             {
                                        if (Function.Call<bool>(Hash.IS_ENTITY_A_VEHICLE, TKEntity))
                                        {
                                                if (TKLength > 3.5f)
                                                       TKLength = TKLength - 0.5f;
                                        }
                                        else
                                        {
                                                if (TKLength > 1.5f)
                                                       TKLength = TKLength - 0.5f;
                                        }
                             }
                     }
            }
        } 

        private void OnKeyDown(object sender, KeyEventArgs e)
        {

        }

        private void OnKeyUp(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Q && !e.Shift)
            {
                    if (TKEntity != null)
                    {
                             if (Function.Call<bool>(Hash.IS_ENTITY_A_PED, TKEntity))
                             {
                                      Function.Call(Hash.SET_PED_GRAVITY, TKEntity, true);
                                      Function.Call(Hash.SET_PED_CAN_RAGDOLL, TKEntity, true);
                             }
                             else
                             {
                                      Function.Call(Hash.SET_ENTITY_HAS_GRAVITY, TKEntity, true);
                             }
                             TKEntity = null;
                             TKLength = 2.5f;
                             RDR2.UI.Screen.ShowSubtitle("Telekinesis Off");
                    }
                    else
                    {
                              OutputArgument entTarget = new OutputArgument();
                              if (Function.Call<bool>(Hash.IS_PLAYER_FREE_AIMING, player))
                              {
                                         bool IsAmining = Function.Call<bool>(Hash.GET_ENTITY_PLAYER_IS_FREE_AIMING_AT, player, entTarget);
                                         if (IsAmining)
                                         {
                                                 TKEntity = entTarget.GetResult<Entity>();
                                         }
                                        TKLength = World.GetDistance(playerPed.Position, TKEntity.Position);  
                                        if (Function.Call<bool>(Hash.IS_ENTITY_A_PED, TKEntity))
                                        {
                                                Function.Call(Hash.SET_PED_GRAVITY, TKEntity, false);
                                                if (!Function.Call<bool>(Hash.IS_PED_HUMAN, TKEntity))
                                                            Function.Call(Hash.SET_PED_CAN_RAGDOLL, TKEntity, false);
                                        }
                                        else
                                        {
                                                Function.Call(Hash.SET_ENTITY_HAS_GRAVITY, TKEntity, false);
                                        }
                              }
                              else
                              {
                                        bool IsTargeting = Function.Call<bool>(Hash.GET_PLAYER_TARGET_ENTITY, player, entTarget);
                                        if (IsTargeting)
                                        {
                                                  TKEntity = entTarget.GetResult<Entity>();
                                        }
                                        TKLength = World.GetDistance(playerPed.Position, TKEntity.Position);  
                                        if (Function.Call<bool>(Hash.IS_ENTITY_A_PED, TKEntity))
                                        {
                                                Function.Call(Hash.SET_PED_GRAVITY, TKEntity, false);
                                                if (!Function.Call<bool>(Hash.IS_PED_HUMAN, TKEntity))
                                                            Function.Call(Hash.SET_PED_CAN_RAGDOLL, TKEntity, false);
                                        }
                                        else
                                        {
                                                Function.Call(Hash.SET_ENTITY_HAS_GRAVITY, TKEntity, false);
                                        }
                              }
                    }
            }
            if (e.KeyCode == Keys.D1 && !e.Shift && TKEntity == null)
            {
                  Ped playerPed = Game.Player.Character;   
                  Vector3 TargetSpace = new Vector3(RotToDir(NC_Get_Cam_Rotation()).X * 1000f, RotToDir(NC_Get_Cam_Rotation()).Y * 1000f, RotToDir(NC_Get_Cam_Rotation()).Z * 1000f);
                  Vector3 TargetPosition = GameplayCamera.Position + TargetSpace;
                  World.ShootBullet(GameplayCamera.Position, TargetPosition, playerPed, 0x20D13FF, 100);
            }
            if (e.KeyCode == Keys.D2 && !e.Shift && TKEntity == null)
            {
                  Ped playerPed = Game.Player.Character;   
                  Vector3 TargetSpace = new Vector3(RotToDir(NC_Get_Cam_Rotation()).X * 1000f, RotToDir(NC_Get_Cam_Rotation()).Y * 1000f, RotToDir(NC_Get_Cam_Rotation()).Z * 1000f);
                  Vector3 TargetPosition = GameplayCamera.Position + TargetSpace;
                  World.ShootBullet(GameplayCamera.Position, TargetPosition, playerPed, 0x31B7B9FE, 150);
            }
            if (e.KeyCode == Keys.D3 && !e.Shift)
            {
                    if (TKEntity == null)
                    {
                              EXPNumber = 1;
                              Function.Call(Hash.SET_PLAYER_INVINCIBLE, player, true);  
                              Vector3 Shockspace = new Vector3(RotToDir(NC_Get_Cam_Rotation()).X * 2.5f, RotToDir(NC_Get_Cam_Rotation()).Y * 2.5f, RotToDir(NC_Get_Cam_Rotation()).Z * 2.5f);
                              while (EXPNumber < MaxEXP || EXPNumber == MaxEXP)
                              {
                                          Function.Call(Hash.ADD_EXPLOSION, (playerPed.Position.X + EXPNumber*Shockspace.X), (playerPed.Position.Y + EXPNumber*Shockspace.Y), (playerPed.Position.Z + EXPNumber*Shockspace.Z), 32, 3f, true, false, 0);
                                          EXPNumber = EXPNumber + 1;
                              }
                              Function.Call(Hash.SET_PLAYER_INVINCIBLE, player, false); 
                              EXPNumber = 1;
                    }
                    else
                    {
                             Vector3 TKPosition = playerPed.Position + new Vector3(0, 0, 0.5f);
                             TKEntity.ApplyForce((TKEntity.Position - TKPosition) * 100f / (TKEntity.Position - TKPosition).Length()); 
                             if (Function.Call<bool>(Hash.IS_ENTITY_A_PED, TKEntity))
                             {
                                      Function.Call(Hash.SET_PED_GRAVITY, TKEntity, true);
                                      Function.Call(Hash.SET_PED_CAN_RAGDOLL, TKEntity, true);
                             }
                             else
                             {
                                      Function.Call(Hash.SET_ENTITY_HAS_GRAVITY, TKEntity, true);
                             }
                             TKEntity = null;
                             TKLength = 2.5f;
                             RDR2.UI.Screen.ShowSubtitle("Telekinesis Off");
                    }
            }
            if (e.KeyCode == Keys.D4 && !e.Shift)
            {
                    if (TKEntity == null)
                    {
                              if (!EXPCasting)
                              {
                                        Function.Call(Hash.SET_PLAYER_INVINCIBLE, player, true);  
                                        Function.Call(Hash.ADD_EXPLOSION, (playerPed.Position.X), (playerPed.Position.Y), (playerPed.Position.Z - 0.5f), 32, 6.0f, true, false, 0);
                                        Function.Call(Hash.ADD_EXPLOSION, (playerPed.Position.X), (playerPed.Position.Y), (playerPed.Position.Z - 0.5f), 32, 5.0f, true, false, 0);
                                        EXPCasting = true;
                                        Wait(200);
                                        Function.Call(Hash.SET_PLAYER_INVINCIBLE, player, false); 
                                        EXPCasting = false;
                              }
                     }
                    else
                    {
                             Function.Call(Hash.ADD_EXPLOSION, (TKEntity.Position.X), (TKEntity.Position.Y), (TKEntity.Position.Z), 23, 1.0f, true, false, 0);
                             if (Function.Call<bool>(Hash.IS_ENTITY_A_PED, TKEntity))
                             {
                                      Function.Call(Hash.SET_PED_GRAVITY, TKEntity, true);
                                      Function.Call(Hash.SET_PED_CAN_RAGDOLL, TKEntity, true);
                                      if (Function.Call<bool>(Hash.IS_PED_HUMAN, TKEntity) && !Function.Call<bool>(Hash.IS_PED_RAGDOLL, TKEntity))
                                                  Function.Call(Hash.SET_PED_TO_RAGDOLL, TKEntity, 10, 10, 1, true, true, true);
                             }
                             else
                             {
                                      Function.Call(Hash.SET_ENTITY_HAS_GRAVITY, TKEntity, true);
                             }
                             TKEntity = null;
                             TKLength = 2.5f;
                             RDR2.UI.Screen.ShowSubtitle("Telekinesis Off");
                    }
            }
        }

        public Vector3 RotToDir(Vector3 Rot)
        {
            try
            {
                float z = Rot.Z;
                float retz = z * 0.0174532924F;
                float x = Rot.X;
                float retx = x * 0.0174532924F;
                float absx = (float)System.Math.Abs(System.Math.Cos(retx));
                return new Vector3((float)-System.Math.Sin(retz) * absx, (float)System.Math.Cos(retz) * absx, (float)System.Math.Sin(retx));
            }
            catch
            {
                return new Vector3(0, 0, 0);
            }
        }

        public Vector3 NC_Get_Cam_Position()
        {
            try
            {
                return Function.Call<Vector3>(Hash.GET_GAMEPLAY_CAM_COORD);
            }
            catch
            {

            }
            return new Vector3(0, 0, 0);
        }

        public Vector3 NC_Get_Cam_Rotation()
        {
            try
            {
                return Function.Call<Vector3>(Hash.GET_GAMEPLAY_CAM_ROT, 0);
            }
            catch
            {

            }
            return new Vector3(0, 0, 0);
        } 
    }
}
